<?php 

error_reporting(E_ALL);
ini_set('display_errors', '1');


	session_start();	
	date_default_timezone_set("America/Mexico_City");	

	if(empty($_SESSION['usuario_autenticado'])){
		header('Location: auth.php');
	}


require_once('fpdf/fpdf.php');
require_once('db/db.php');
require_once('db/TableModel.php');


class pdf extends FPDF
{
	
	public function header()
	{
		$logotext="img/logotext.png";
		$this->SetFillColor(68,211,99);
		$this->Rect(0,0,220,40,'F');
		$this->Image($logotext , 10,10, '' , 20,'PNG','http://www.sicanetsc.com/');
		$this->SetFont('Arial','B',18);
		$this->SetTextColor(255,255,255);
		$this->SeTY(20);
		$this->SeTX(100);
		$this->Write(5,'Diccionario de Datos');
		$this->SeTY(45);
		$this->SeTX(30);
	}

	public function footer()
	{
		$icon_ubicacion = "img/icon_ubic.png";
		$icon_tel = "img/icon_tel.png";
		#$this->Image($icon_ubicacion , 10 ,0, 5 , 5,'PNG'); -> (x,y,ancho,alto)
		$this->Image($icon_ubicacion , 20 ,$this->SeTY(-20), 4 , 4,'PNG');
		$this->SetFont('Courier','B',12);
		$this->SeTY(-20);
		$this->SeTX(27);
		$this->SetTextColor(77,78,79);
		$this->Write(5,utf8_decode('Moctezuma 105 Col. Nacional Sta. Lucia del Camino Oaxaca, México.'));
		$this->Image($icon_tel , 20 ,$this->SeTY(-15), 4 , 4,'PNG');
		$this->SeTY(-15);
		$this->SeTX(27);
		$this->Write(5,'Tel (951) 516-8615.');

	}

	function vcell($c_width,$c_height,$x_axis,$text,$number_len){ 
		$w_w=$c_height/3; // -> altura/3 
		$w_w_1=$w_w+2; // -> (altura/3) + 2
		$w_w1=$w_w+$w_w+$w_w+3; // ((altura/3) + (altura/3) + (altura/3) + 3) 
		$w_w1_w2=$w_w+$w_w+$w_w+8;
		$len=strlen($text);// check the length of the cell and splits the text into 7 character each and saves in a array 
		if($len>$number_len){ 
			$w_text=str_split($text,$number_len); 
			$this->SetX($x_axis); 
			$this->Cell($c_width,$w_w_1,$w_text[0],'','',''); 
			$this->SetX($x_axis); 
			$this->Cell($c_width,$w_w1,$w_text[1],'','','');
			if (!empty($w_text[2])) {
				$this->SetX($x_axis); 
				$this->Cell($c_width,$w_w1_w2,$w_text[2],'','','');
			}
			$this->SetX($x_axis); 
			$this->Cell($c_width,$c_height,'','LTRB',0,'L',0); 
		}else{ 
		    $this->SetX($x_axis); 
		    $this->Cell($c_width,$c_height,$text,'LTRB',0,'L',0);
		} 
	}
}

$fpdf = new pdf('P','mm','letter',true);
$fpdf->AddPage('portrait','letter');
#Establecemos los márgenes izquierda, arriba y derecha:
$fpdf->SetMargins(15, 10 , 10);
#Establecemos el margen inferior:
$fpdf->SetAutoPageBreak(true,30); 

$icon_base = "img/icon_base.png";
$icon_puerto = "img/icon_puerto.png";

$fpdf->Image($icon_base , 25 ,45, 5 , 5,'PNG');
$fpdf->SetFont('Times','',12);
$fpdf->SeTY(45);
$fpdf->SeTX(30);
$fpdf->Write(5,'Base de datos: Sicanet_Solidez_Desarrollo');
$fpdf->Image($icon_puerto , 120 ,45, 5 , 5,'PNG');
$fpdf->SeTY(45);
$fpdf->SeTX(125);
$fpdf->Write(5,'Puerto: 3306');
$fpdf->Ln();
$fpdf->Ln();

$tableModel = new TableModel();

$data_tablas = $tableModel->listar_tablas();

foreach ($data_tablas as $obj){

	//vcell($c_width,$c_height,$x_axis,$text,$number_len)

	//nombre tabla
	$fpdf->SetFont('Arial','B',10); 
	$fpdf->SetTextColor(51,119,255);
	$fpdf->Cell(190,6,$obj->nombre,1,1,'C');

	//descripcion tabla
	$fpdf->SetTextColor(9,26,60);
	$fpdf->SetFont('Arial','B',8); 
	//config vcell
	$x_axis=$fpdf->getx();
	$fpdf->vcell(190,8,$x_axis,utf8_decode($obj->descripcion ),130);
	$fpdf->SetFont('Courier','',8);

	//encabezado parametros
	$fpdf->Ln();
	
	$fpdf->SetTextColor(255,255,255);
	$fpdf->SetFillColor(118,118,118);
	$fpdf->SetDrawColor(108,94,94); 
	$fpdf->Cell(60,6,'CAMPO',1,0,'C',1);
	$fpdf->Cell(21,6,'TIPO',1,0,'C',1);
	$fpdf->Cell(13,6,'DEFAULT',1,0,'C',1);
	$fpdf->Cell(9,6,'NULL',1,0,'C',1);
	$fpdf->Cell(9,6,'KEY',1,0,'C',1);
	$fpdf->Cell(78,6,'DESCRIPCION',1,0,'C',1);
	$fpdf->Ln();

	$data_parametros = $tableModel->listar_campos($obj->nombre);
	foreach ($data_parametros as $obj_prmts) {
	 	# code...
	 	$fpdf->SetFont('Arial','',7);
	 	$fpdf->SetTextColor(9,26,60);
	 	$fpdf->SetDrawColor(108,94,94);

	 	//config vcell
		$x_axis=$fpdf->getx();
		$fpdf->vcell(60,11,$x_axis,utf8_decode($obj_prmts->nombre),40);
		$x_axis=$fpdf->getx();
	 	$fpdf->vcell(21,11,$x_axis,utf8_decode($obj_prmts->tipo),14);
	 	$x_axis=$fpdf->getx();
	 	$fpdf->SetFont('Arial','',6);
	 	$fpdf->vcell(13,11,$x_axis,utf8_decode($obj_prmts->valor_default),8);
	 	$fpdf->SetFont('Arial','',7);
	 	$x_axis=$fpdf->getx();
	 	$fpdf->vcell(9,11,$x_axis,utf8_decode($obj_prmts->acepta_null),5);
	 	$x_axis=$fpdf->getx();
	 	$fpdf->vcell(9,11,$x_axis,$obj_prmts->es_key,5);
	 	$x_axis=$fpdf->getx();
	 	$fpdf->SetFont('Arial','',6);
	 	$fpdf->vcell(78,11,$x_axis,utf8_decode($obj_prmts->descripcion),68);

	 	$fpdf->Ln();
	 }

	$fpdf->Ln();
	$fpdf->Ln();
}

$fpdf->OutPut('I','diccionario.pdf',false);

?>